#include <Core/Core.h>
#include <SSH/SSH.h>

using namespace Upp;

// SshExec.cpp: 
// Demonstates remote command execution on an ssh channel.

// A popular public test server:
// -----------------------------
// Host:     test.rebex.net
// User:     user
// Password: password
// Command:  ls -l

CONSOLE_APP_MAIN
{
	Ssh session;
	Cout() << "Hostname: ";
	auto host = ReadStdIn();
	Cout() << "Username: ";
	auto user = ReadStdIn();
	Cout() << "Password: ";
	auto pass = ReadStdIn();
	const int port = 22;

	if(session.Connect(host, port, user, pass)) {
		Cout() << "Command: ";
		auto cmd = ReadStdIn();
		Exec xc(session);
		auto rc = xc(cmd, Cout(), Cerr());
		if(xc.IsFailure()) Cerr() << Format("Exec failed. %s", xc.GetErrorDesc());
		else Cout() << Format("Remote program exited with code: %d\n", rc);
	}
	else Cerr() << session.GetErrorDesc() << '\n';
}
